<?php

namespace App\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('username', 'email', 'company_id', 'costumer_id', 'password');
    protected $visible = array('username', 'email', 'company_id', 'costumer_id');
    protected $hidden = array('password');

    public function owner()
    {
        return $this->morphTo();
    }

}